<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Candid Chronicles - Home</title>
  <meta name="viewport" content="width=device-width, initial-scale=1"> 
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
  <style>
    .container ul li a {
   text-decoration: none; 
   background: linear-gradient(to right, #ffecd2, #fcb69f); 
   -webkit-background-clip: text;
    -webkit-text-fill-color: transparent; 
    font-weight: 800; 
  transition: color 0.3s ease;
}
.container ul li::after{
    content: '';
    width: 0%;
    height: 2px;
    background: goldenrod;
    display: block;
        margin: auto;
        transition: 0.5s;
}
.container ul li:hover::after{
    width: 100%;
}
.navbar-brand{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  background-clip: text;
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}
.dropdown-menu{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
}
.display-5{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  background-clip: text;
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}
.btn-primary{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  border: none;
}
.mb-4.text-center{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  background-clip: text;
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}
    </style>

<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container">
    
    <a class="navbar-brand fw-bold" href="<?php echo e(route('posts.index')); ?>">
      Candid Chronicles
    </a>

    
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarMain"
            aria-controls="navbarMain" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>

    
    <div class="collapse navbar-collapse" id="navbarMain">
      <ul class="navbar-nav ms-auto mb-2 mb-lg-0">

        
        <li class="nav-item">
          <a href="<?php echo e(route('posts.index')); ?>"
             class="nav-link <?php echo e(request()->routeIs('posts.index') ? 'active' : ''); ?>">
            Home
          </a>
        </li>

        
        <li class="nav-item">
          <a href="<?php echo e(route('about')); ?>"
             class="nav-link <?php echo e(request()->routeIs('about') ? 'active' : ''); ?>">
            About
          </a>
        </li>

        
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle <?php echo e(request()->routeIs('category.show') ? 'active' : ''); ?>"
             href="#" id="navbarDropdown" role="button"
             data-bs-toggle="dropdown" aria-expanded="false">
            Categories
          </a>
          <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
            <li><a class="dropdown-item" href="<?php echo e(route('category.show', 'news')); ?>">News</a></li>
            <li><a class="dropdown-item" href="<?php echo e(route('category.show', 'story')); ?>">Story</a></li>
            <li><a class="dropdown-item" href="<?php echo e(route('category.show', 'lifestyle')); ?>">Lifestyle</a></li>
          </ul>
        </li>

        
        <li class="nav-item">
          <a href="<?php echo e(route('archive.year', now()->year)); ?>"
             class="nav-link <?php echo e(request()->routeIs('archive.*') ? 'active' : ''); ?>">
            Archive
          </a>
        </li>

        
        <li class="nav-item">
          <a href="<?php echo e(route('contact')); ?>"
             class="nav-link <?php echo e(request()->routeIs('contact') ? 'active' : ''); ?>">
            Contact
          </a>
        </li>

        
        <li class="nav-item ms-lg-3">
          <?php if(auth('admin')->check()): ?>
            <a href="<?php echo e(route('admin.posts.index')); ?>" class="btn btn-outline-light btn-sm me-2">
              Admin Dashboard
            </a>
            <form action="<?php echo e(route('admin.logout')); ?>" method="POST" class="d-inline">
              <?php echo csrf_field(); ?>
              <button type="submit" class="btn btn-danger btn-sm">Logout</button>
            </form>
          <?php else: ?>
            <a href="<?php echo e(route('admin.login')); ?>" class="btn btn-outline-light btn-sm">
              Admin Login
            </a>
          <?php endif; ?>
        </li>

      </ul>
    </div>
  </div>
</nav>


<header class="py-5 bg-white border-bottom">
  <div class="container">
    <div class="row align-items-center gy-4">
      <div class="col-lg-7">
        <h1 class="display-5 fw-bold">Candid Chronicles</h1>
        <p class="lead text-muted">
          Real stories. Honest news. Everyday lifestyle moments – all in one place.
        </p>
      </div>
      <div class="col-lg-5">
        <form method="GET" action="<?php echo e(route('posts.index')); ?>" class="d-flex gap-2">
          <input
            type="text"
            name="q"
            class="form-control"
            placeholder="Search stories, news, lifestyle..."
            value="<?php echo e($search ?? ''); ?>"
          >
          <button class="btn btn-primary" type="submit">Search</button>
        </form>
      </div>
    </div>
  </div>
</header>


<div class="container py-5">

  
  <?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
      <?php echo e(session('success')); ?>

      <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
  <?php endif; ?>

  <h2 class="mb-4 text-center">Latest Posts</h2>

  <?php if($posts->count()): ?>
    <div class="row">
      <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-md-6 col-lg-4 mb-4">
          <div class="card h-100 shadow-sm">

            <?php if($post->image): ?>
              <img src="<?php echo e(asset('storage/' . $post->image)); ?>" class="card-img-top" alt="Post image">
            <?php endif; ?>

            <div class="card-body d-flex flex-column">
              <small class="text-uppercase text-muted">
                <?php echo e(ucfirst($post->category ?? 'general')); ?>

              </small>

              <h5 class="card-title mt-1">
                <?php echo e($post->title); ?>

              </h5>

              <p class="card-text text-muted small mb-1">
                <?php echo e($post->created_at->format('M d, Y')); ?>

                · 👁 <?php echo e($post->views ?? 0); ?> views
              </p>

              <p class="card-text text-muted">
                <?php echo e(\Illuminate\Support\Str::limit(strip_tags($post->body), 120)); ?>

              </p>

              
              <?php if($post->video): ?>
                <span class="badge bg-secondary mb-2">🎥 Includes video</span>
              <?php endif; ?>

              <div class="mt-auto d-flex justify-content-between align-items-center">
                <a href="<?php echo e(route('posts.show', $post->slug)); ?>" class="btn btn-sm btn-primary">
                  Read More
                </a>
                <div class="text-muted small">
                  👍 <?php echo e($post->likes->count() ?? 0); ?>

                  &nbsp;·&nbsp;
                  💬 <?php echo e($post->comments->count() ?? 0); ?>

                </div>
              </div>

              <div class="text-muted small">
  👁️ <?php echo e($post->views ?? 0); ?>

  &nbsp;·&nbsp;
  👍 <?php echo e($post->likes->count() ?? 0); ?>

  &nbsp;·&nbsp;
  💬 <?php echo e($post->comments->count() ?? 0); ?>

</div>


              
              <?php if(auth('admin')->check()): ?>
                <div class="mt-3 d-flex gap-2">
                  <a href="<?php echo e(route('admin.posts.edit', $post)); ?>" class="btn btn-sm btn-outline-primary">
                    ✏️ Edit
                  </a>
                  <form action="<?php echo e(route('admin.posts.destroy', $post)); ?>" method="POST"
                        onsubmit="return confirm('Delete this post?');">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button class="btn btn-sm btn-outline-danger" type="submit">
                      🗑️ Delete
                    </button>
                  </form>
                </div>
              <?php endif; ?>

            </div>
          </div>
        </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    
    <div class="d-flex justify-content-center mt-4">
      <?php echo e($posts->links()); ?>

    </div>

  <?php else: ?>
    <p class="text-center text-muted">No posts available yet.</p>
  <?php endif; ?>

</div>

<footer class="py-4 bg-dark text-light mt-auto">
  <div class="container d-flex flex-column flex-md-row justify-content-between align-items-center">
    <div>
      © <?php echo e(date('Y')); ?> Candid Chronicles. All rights reserved.
    </div>
    <div class="mt-2 mt-md-0">
      <a href="https://twitter.com/CandidChro4351" class="text-light text-decoration-none me-3">Twitter</a>
      <a href="https://www.instagram.com/candid_chronicles00/" class="text-light text-decoration-none me-3">Instagram</a>
      <a href="https://www.facebook.com/share/1CW8Pn4ws9/?mibextid=wwXIfr" class="text-light text-decoration-none">Facebook</a>
    </div>
    <div class="mt-2 mt-md-0">
    <a href="<?php echo e(route('privacy.policy')); ?>">Privacy Policy</a>
    | <a href="<?php echo e(route('terms')); ?>">Terms & Conditions</a>
  |
<a href="<?php echo e(route('contact')); ?>">Contact</a>
  </div>

  </div>
</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\blog\resources\views/posts/index.blade.php ENDPATH**/ ?>